from model import make_param_space
import pymor.basic as pmb

import argparse


def make_parser():
    parser = argparse.ArgumentParser(description='Write n parameter values to a file using the parameter space specified in main',
                                     prefix_chars='-')
    parser.add_argument('-o', '--output_file',
                        help='output_filename',
                        type=str,
                        default='param.pkl')
    parser.add_argument('nb',
                        help='number of parameter values',
                        type=int)
    return parser


# Write n parameter values to a file using the parameter space specified in main
# Usage : python3 writeparam.py [-o output_filename] n
# The output filename defaults to param.pkl
if __name__=='__main__':
    args = make_parser().parse_args()
    
    param_space = make_param_space()
    
    param_set = param_space.sample_randomly(args.nb)
    pmb.dump(param_set, open(args.output_file, 'wb'))
    