import qarnot

def job():
    conn = qarnot.Connection('qarnot.conf')
    job = conn.create_job('rom-job', useDependencies=True)
    job.submit()
    print(job)
    
    task1 = conn.create_task('hello-1', 'docker-batch', job=job)
    task1.constants['DOCKER_CMD'] = 'sh -c "echo hello world from task 1 && sleep 100"'
    task1.submit()
    
    task2 = conn.create_task('hello-2', 'docker-batch', job=job)
    task2.constants['DOCKER_CMD'] = 'sh -c "echo hello world from task 2 && sleep 100"'
    task2.set_task_dependencies_from_tasks([task1])
    task2.submit()


def opt_test():
    import sys
    import getopt
    
    args, rest = getopt.getopt(sys.argv[1:], 'n:o:i:')
    args = dict(args)
    if '-n' in args.keys():
        print(f'computing for {args["-n"]} param values')
    if '-o' in args.keys():
        print(f'output file: {args["-o"]}')
    if '-i' in args.keys():
        print(f'input param file: {args["-i"]}')
    print(rest)


def task():
    conn = qarnot.Connection('qarnot.conf')
    bucket1 = conn.retrieve_bucket('rom-validate-output')
    bucket2 = conn.retrieve_bucket('rom-training-output')
    
    task = conn.create_task('ls', 'docker-batch', 1)
    task.constants['DOCKER_CMD'] = 'ls -R '
    task.resources.append(bucket1)
    task.resources.append(bucket2)
    
    task.submit()


if __name__=='__main__':
    opt_test()
    