#!/usr/bin/env python3

"""word_count.py"""
import sys
import pyspark
from pyspark import SparkContext

conf = pyspark.SparkConf().set("spark.driver.host", sys.argv[1])

sc = SparkContext(conf=conf)
lines = sc.textFile("/job/iliad.txt", minPartitions=6)

word_counts = lines.flatMap(lambda line: line.split(' ')) \
                    .count()

my_file = open("/job/output_iliad.txt", "w")
my_file.write(str(word_counts))
my_file.close()

# for visualization on port 4040, uncomment line below
# input("press ctrl+c to exit")
